'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const FieldContext = require('./FieldContext.js');
const useId = require('../hooks/useId.js');
const Box = require('../Box/Box.js');

const Field = React.forwardRef(({ children, name, error, hint, id, required = false, ...props }, ref) => {
    const generatedId = useId.useId(id);
    const context = React.useMemo(() => ({ name, id: generatedId, error, hint, required }), [error, generatedId, hint, name, required]);
    return (jsxRuntime.jsx(Box.Box, { ref: ref, ...props, children: jsxRuntime.jsx(FieldContext.FieldContext.Provider, { value: context, children: children }) }));
});

exports.Field = Field;
