'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const DividerWrapper = styled__default.default(Box.Box) `
  height: 1px;
  border: none;
  /* If contained in a Flex parent we want to prevent the Divider to shink */
  flex-shrink: 0;
  ${({ unsetMargin }) => (unsetMargin ? 'margin: 0;' : '')}
`;
const Divider = ({ unsetMargin = true, ...props }) => {
    return jsxRuntime.jsx(DividerWrapper, { ...props, background: "neutral150", as: "hr", unsetMargin: unsetMargin });
};

exports.Divider = Divider;
