import { jsx, jsxs } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';

const FooterWrapper = styled(Box) `
  border-top: 1px solid ${({ theme }) => theme.colors.neutral150};

  button {
    width: 100%;
    display: inline-flex;
    justify-content: center;
  }
`;
const DialogFooter = ({ startAction, endAction }) => {
    return (jsx(FooterWrapper, { padding: 4, children: jsxs(Flex, { gap: 2, children: [startAction, endAction] }) }));
};

export { DialogFooter };
