import { jsxs, jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';

const IconContainer = styled(Box) `
  svg {
    width: ${({ theme }) => theme.spaces[6]};
    height: ${({ theme }) => theme.spaces[6]};

    path {
      fill: ${({ theme }) => theme.colors.danger600};
    }
  }
`;
const DialogBody = ({ children, icon }) => {
    return (jsxs(Box, { paddingTop: 8, paddingBottom: 8, paddingLeft: 6, paddingRight: 6, children: [icon && (jsx(IconContainer, { paddingBottom: 2, children: jsx(Flex, { justifyContent: "center", children: icon }) })), children] }));
};

export { DialogBody };
