import { jsx, jsxs } from 'react/jsx-runtime';
import styled from 'styled-components';
import { DismissibleLayer } from '../DismissibleLayer/index.mjs';
import { setOpacity } from '../helpers/setOpacity.mjs';
import { useId } from '../hooks/useId.mjs';
import useLockScroll from '../hooks/useLockScroll.mjs';
import { FocusTrap } from '../FocusTrap/FocusTrap.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Portal } from '../Portal/Portal.mjs';
import { Typography } from '../Typography/Typography.mjs';

const DialogWrapper = styled(Box) `
  inset: 0;
  background: ${({ theme }) => setOpacity(theme.colors.neutral800, 0.2)};
`;
const DialogContainer = styled(Box) `
  max-width: ${412 / 16}rem;
  margin: 0 auto;
  overflow: hidden;
  margin-top: 10%;
`;
const DialogHeader = styled(Flex) `
  border-bottom: 1px solid ${({ theme }) => theme.colors.neutral150};
`;
const Dialog = ({ onClose, title, as = 'h2', isOpen, id, zIndex = 4, ...props }) => {
    const generatedId = useId(id);
    useLockScroll(isOpen);
    if (!isOpen) {
        return null;
    }
    const labelledBy = `${generatedId}-label`;
    return (jsx(Portal, { children: jsx(DialogWrapper, { padding: 8, position: "fixed", zIndex: zIndex, children: jsx(FocusTrap, { children: jsx(DismissibleLayer, { onEscapeKeyDown: onClose, onPointerDownOutside: onClose, children: jsxs(DialogContainer, { "aria-labelledby": labelledBy, "aria-modal": true, background: "neutral0", hasRadius: true, shadow: "popupShadow", role: "dialog", children: [jsx(DialogHeader, { padding: 6, justifyContent: "center", children: jsx(Typography, { variant: "beta", as: as, id: labelledBy, children: title }) }), jsx(Box, { ...props })] }) }) }) }) }));
};

export { Dialog };
