import { jsx, jsxs } from 'react/jsx-runtime';
import * as React from 'react';
import { getLocalTimeZone, parseAbsoluteToLocal, toCalendarDateTime } from '@internationalized/date';
import styled from 'styled-components';
import { DatePickerInput } from '../DatePicker/DatePicker.mjs';
import { useDesignSystem } from '../DesignSystemProvider.mjs';
import { once } from '../helpers/deprecations.mjs';
import { useComposedRefs } from '../hooks/useComposeRefs.mjs';
import { useControllableState } from '../hooks/useControllableState.mjs';
import { useDateFormatter } from '../hooks/useDateFormatter.mjs';
import { useId } from '../hooks/useId.mjs';
import { TimePickerInput } from '../TimePicker/TimePicker.mjs';
import { Field } from '../Field/Field.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { FieldLabel } from '../Field/FieldLabel.mjs';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';
import { FieldHint } from '../Field/FieldHint.mjs';
import { FieldError } from '../Field/FieldError.mjs';

const DateTimePicker = React.forwardRef(({ 
/**
 * @preserve
 * @deprecated This is no longer used.
 */
ariaLabel: _ariaLabel, clearLabel = 'clear', dateLabel = 'Choose date', timeLabel = 'Choose time', disabled = false, error, hint, id, label, labelAction, onChange, onClear, name, required = false, 
/**
 * @preserve
 * @deprecated This is no longer used.
 */
selectButtonTitle: _selectButtonTitle, size = 'M', step, value, initialDate, ...props }, forwardedRef) => {
    const DatePickerElement = React.useRef(null);
    const [dateValue, setDateValue] = useControllableState({
        defaultProp: initialDate ? convertUTCDateToCalendarDateTime(initialDate, false) : undefined,
        prop: value ? convertUTCDateToCalendarDateTime(value, false) : value ?? undefined,
        onChange(date) {
            if (onChange) {
                onChange(date?.toDate(getLocalTimeZone()));
            }
        },
    });
    const context = useDesignSystem('DateTimePicker');
    const timeFormatter = useDateFormatter(context.locale, {
        hour: '2-digit',
        minute: '2-digit',
        hour12: false,
    });
    const timeValue = dateValue ? timeFormatter.format(dateValue.toDate(getLocalTimeZone())) : '';
    // React.useEffect(() => {
    //   setTimeTextValue((s) => (s === timeValue ? s : timeValue));
    // }, [timeValue]);
    const handleDateChange = (date) => {
        let newDate = date ? convertUTCDateToCalendarDateTime(date) : undefined;
        /**
         * If the date hasn't changed, don't do anything.
         */
        if (newDate && dateValue && newDate.compare(dateValue) === 0) {
            return;
        }
        if (timeValue && newDate) {
            const [hours, minutes] = timeValue.split(':');
            newDate = newDate.set({ hour: parseInt(hours, 10), minute: parseInt(minutes, 10) });
        }
        setDateValue(newDate);
    };
    const handleTimeChange = (time) => {
        if (!time) {
            return;
        }
        const [hours, minutes] = time.split(':');
        const dateToSet = dateValue
            ? dateValue.set({ hour: parseInt(hours, 10), minute: parseInt(minutes, 10) })
            : convertUTCDateToCalendarDateTime(new Date()).set({
                hour: parseInt(hours, 10),
                minute: parseInt(minutes, 10),
            });
        setDateValue(dateToSet);
    };
    const handleDateClear = (e) => {
        setDateValue(undefined);
        // setTimeTextValue('');
        if (onClear) {
            onClear(e);
        }
    };
    const handleTimeClear = () => {
        const newDate = dateValue ? dateValue.set({ hour: 0, minute: 0 }) : convertUTCDateToCalendarDateTime(new Date());
        setDateValue(newDate);
        // setTimeTextValue('');
    };
    const generatedId = useId(id);
    const timeId = useId();
    const dateId = useId();
    const composedRefs = useComposedRefs(DatePickerElement, forwardedRef);
    return (jsx(Field, { name: name, as: "fieldset", id: generatedId, "aria-labelledby": generatedId, hint: hint, error: error, required: required, children: jsxs(Flex, { as: "span", direction: "column", alignItems: "stretch", gap: 1, children: [jsx(FieldLabel, { onClick: () => {
                        /**
                         * We're using fieldsets and legends and because they're not directly associated with the input
                         * we want to manually focus the input because the labels for these inputs are visually hidden.
                         */
                        DatePickerElement.current.focus();
                    }, as: "legend", id: generatedId, action: labelAction, children: label }), jsxs(Flex, { flex: "1", gap: 1, children: [jsx(VisuallyHidden, { as: "label", htmlFor: dateId, children: dateLabel }), jsx(DatePicker, { ...props, selectedDate: dateValue?.toDate('UTC'), onChange: handleDateChange, error: typeof error === 'string', required: required, size: size, onClear: onClear ? handleDateClear : undefined, clearLabel: `${clearLabel} date`, disabled: disabled, id: dateId, ref: composedRefs, "aria-describedby": `${generatedId}-hint ${generatedId}-error` }), jsx(VisuallyHidden, { as: "label", htmlFor: timeId, children: timeLabel }), jsx(TimePicker, { size: size, error: typeof error === 'string', value: timeValue, onChange: handleTimeChange, onClear: onClear && timeValue !== undefined && timeValue !== '00:00' ? handleTimeClear : undefined, clearLabel: `${clearLabel} time`, required: required, disabled: disabled, step: step, id: timeId, "aria-describedby": `${generatedId}-hint ${generatedId}-error` })] }), jsx(FieldHint, {}), jsx(FieldError, {})] }) }));
});
const warnOnce = once(console.warn);
const convertUTCDateToCalendarDateTime = (date, resetTime = true) => {
    /**
     * TODO: remove this in V2, it's a deprecated API
     */
    if (typeof date === 'string') {
        warnOnce("It looks like you're passing a string as representation of a Date to the DatePicker. This is deprecated, look to passing a Date instead.");
        const timestamp = Date.parse(date);
        if (!Number.isNaN(timestamp)) {
            date = new Date(timestamp);
        }
        else {
            date = new Date();
        }
    }
    const utcDateString = date.toISOString();
    let zonedDateTime = parseAbsoluteToLocal(utcDateString);
    if (resetTime) {
        zonedDateTime = zonedDateTime.set({ hour: 0, minute: 0 });
    }
    /**
     * ZonedDateTime can't have weeks added,
     * see – https://github.com/adobe/react-spectrum/issues/3667
     */
    return toCalendarDateTime(zonedDateTime);
};
const DatePicker = styled(DatePickerInput) `
  flex: 1 1 70%;
  min-width: 120px;
`;
const TimePicker = styled(TimePickerInput) `
  flex: 1 1 30%;
  min-width: 140px;
`;

export { DateTimePicker, convertUTCDateToCalendarDateTime };
