'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const uiPrimitives = require('@strapi/ui-primitives');
const styled = require('styled-components');
const strings = require('../helpers/strings.js');
const useComposeRefs = require('../hooks/useComposeRefs.js');
const useControllableState = require('../hooks/useControllableState.js');
const useId = require('../hooks/useId.js');
const useIntersection = require('../hooks/useIntersection.js');
const Loader = require('../Loader/Loader.js');
const utils = require('../themes/utils.js');
const Flex = require('../Flex/Flex.js');
const Box = require('../Box/Box.js');
const Typography = require('../Typography/Typography.js');
const Field = require('../Field/Field.js');
const FieldLabel = require('../Field/FieldLabel.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const ComboboxInput = React__namespace.forwardRef(({ allowCustomValue, autocomplete, children, className, clearLabel = 'clear', creatable = false, createMessage = (value) => `Create "${value}"`, defaultFilterValue, defaultTextValue, defaultOpen = false, open, onOpenChange, disabled = false, error, filterValue, hasMoreItems = false, id, isPrintableCharacter, loading = false, loadingMessage = 'Loading content...', noOptionsMessage = () => 'No results found', onChange, onClear, onCreateOption, onFilterValueChange, onInputChange, onTextValueChange, onLoadMore, placeholder = 'Select or enter a value', required = false, size = 'M', startIcon, textValue, value, ...restProps }, forwardedRef) => {
    const [internalIsOpen, setInternalIsOpen] = useControllableState.useControllableState({
        prop: open,
        defaultProp: defaultOpen,
        onChange: onOpenChange,
    });
    const [internalTextValue, setInternalTextValue] = useControllableState.useControllableState({
        prop: textValue,
        defaultProp: allowCustomValue && !defaultTextValue ? value : defaultTextValue,
        onChange: onTextValueChange,
    });
    const [internalFilterValue, setInternalFilterValue] = useControllableState.useControllableState({
        prop: filterValue,
        defaultProp: defaultFilterValue,
        onChange: onFilterValueChange,
    });
    /**
     * Used for the intersection observer
     */
    const viewportRef = React__namespace.useRef(null);
    const triggerRef = React__namespace.useRef(null);
    const composedTriggerRefs = useComposeRefs.useComposedRefs(triggerRef, forwardedRef);
    const clearRef = React__namespace.useRef(null);
    const handleClearClick = (e) => {
        if (onClear && !disabled) {
            setInternalTextValue('');
            setInternalFilterValue('');
            onClear(e);
            triggerRef.current.focus();
        }
    };
    const handleOpenChange = (open) => {
        setInternalIsOpen(open);
    };
    const handleTextValueChange = (textValue) => {
        setInternalTextValue(textValue);
    };
    const handleFilterValueChange = (filterValue) => {
        setInternalFilterValue(filterValue);
    };
    const handleInputChange = (e) => {
        if (onInputChange) {
            onInputChange(e);
        }
    };
    const handleChange = (value) => {
        if (onChange) {
            onChange(value);
        }
    };
    const handleReachEnd = (entry) => {
        if (onLoadMore && hasMoreItems && !loading) {
            onLoadMore(entry);
        }
    };
    const handleCreateItemClick = () => {
        if (onCreateOption && internalTextValue) {
            onCreateOption(internalTextValue);
        }
    };
    const generatedId = useId.useId(id);
    const generatedIntersectionId = useId.useId();
    const intersectionId = `intersection-${strings.stripReactIdOfColon(generatedIntersectionId)}`;
    useIntersection.useIntersection(viewportRef, handleReachEnd, {
        selectorToWatch: `#${intersectionId}`,
        /**
         * We need to know when the select is open because only then will viewportRef
         * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
         */
        skipWhen: !internalIsOpen,
    });
    const hintId = `${generatedId}-hint`;
    const errorId = `${generatedId}-error`;
    return (jsxRuntime.jsxs(uiPrimitives.Combobox.Root, { autocomplete: autocomplete || (creatable ? 'list' : 'both'), onOpenChange: handleOpenChange, open: internalIsOpen, onTextValueChange: handleTextValueChange, textValue: internalTextValue, allowCustomValue: creatable || allowCustomValue, disabled: disabled, required: required, value: value, onValueChange: handleChange, filterValue: internalFilterValue, onFilterValueChange: handleFilterValueChange, isPrintableCharacter: isPrintableCharacter, children: [jsxRuntime.jsxs(Trigger, { "$hasError": Boolean(error), "$size": size, className: className, children: [jsxRuntime.jsxs(Flex.Flex, { flex: "1", as: "span", gap: 3, children: [startIcon ? (jsxRuntime.jsx(Box.Box, { as: "span", "aria-hidden": true, children: startIcon })) : null, jsxRuntime.jsx(TextInput, { placeholder: placeholder, id: id, "aria-invalid": Boolean(error), "aria-describedby": `${hintId} ${errorId}`, onChange: handleInputChange, ref: composedTriggerRefs, ...restProps })] }), jsxRuntime.jsxs(Flex.Flex, { as: "span", gap: 3, children: [internalTextValue && onClear ? (jsxRuntime.jsx(IconBox, { as: "button", hasRadius: true, background: "transparent", type: "button", onClick: handleClearClick, "aria-disabled": disabled, "aria-label": clearLabel, title: clearLabel, ref: clearRef, children: jsxRuntime.jsx(icons.Cross, {}) })) : null, jsxRuntime.jsx(DownIcon, { children: jsxRuntime.jsx(icons.CarretDown, {}) })] })] }), jsxRuntime.jsx(uiPrimitives.Combobox.Portal, { children: jsxRuntime.jsx(Content, { sideOffset: 4, children: jsxRuntime.jsxs(Viewport, { ref: viewportRef, children: [children, creatable ? (jsxRuntime.jsx(uiPrimitives.Combobox.CreateItem, { onPointerUp: handleCreateItemClick, onClick: handleCreateItemClick, asChild: true, children: jsxRuntime.jsx(OptionBox, { children: jsxRuntime.jsx(Typography.Typography, { children: createMessage(internalTextValue ?? '') }) }) })) : null, !creatable && !loading ? (jsxRuntime.jsx(uiPrimitives.Combobox.NoValueFound, { asChild: true, children: jsxRuntime.jsx(OptionBox, { "$hasHover": false, children: jsxRuntime.jsx(Typography.Typography, { children: noOptionsMessage(internalTextValue ?? '') }) }) })) : null, loading ? (jsxRuntime.jsx(Flex.Flex, { justifyContent: "center", alignItems: "center", paddingTop: 2, paddingBottom: 2, children: jsxRuntime.jsx(Loader.Loader, { small: true, children: loadingMessage }) })) : null, jsxRuntime.jsx(Box.Box, { id: intersectionId, width: "100%", height: "1px" })] }) }) })] }));
});
const Combobox = React__namespace.forwardRef(({ error, hint, id, label, labelAction, required = false, ...restProps }, forwardedRef) => {
    const generatedId = useId.useId(id);
    return (jsxRuntime.jsx(Field.Field, { hint: hint, error: error, id: generatedId, required: required, children: jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label ? jsxRuntime.jsx(FieldLabel.FieldLabel, { action: labelAction, children: label }) : null, jsxRuntime.jsx(ComboboxInput, { ref: forwardedRef, id: generatedId, error: error, required: required, ...restProps }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }));
});
const CreatableCombobox = (props) => jsxRuntime.jsx(Combobox, { ...props, creatable: true });
const IconBox = styled__default.default(Box.Box) `
  border: none;

  svg {
    height: ${11 / 16}rem;
    width: ${11 / 16}rem;
  }

  svg path {
    fill: ${({ theme }) => theme.colors.neutral600};
  }
`;
const Trigger = styled__default.default(uiPrimitives.Combobox.Trigger) `
  position: relative;
  border: 1px solid ${({ theme, $hasError }) => ($hasError ? theme.colors.danger600 : theme.colors.neutral200)};
  padding-right: ${({ theme }) => theme.spaces[3]};
  padding-left: ${({ theme }) => theme.spaces[3]};
  border-radius: ${({ theme }) => theme.borderRadius};
  background: ${({ theme }) => theme.colors.neutral0};
  overflow: hidden;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: ${({ theme }) => theme.spaces[4]};
  min-height: ${({ theme, $size }) => utils.getThemeSize('input')({ theme, size: $size })};

  &[data-disabled] {
    color: ${({ theme }) => theme.colors.neutral600};
    background: ${({ theme }) => theme.colors.neutral150};
    cursor: not-allowed;
  }

  /* Required to ensure the below inputFocusStyles are adhered too */
  &:focus-visible {
    outline: none;
  }

  ${({ theme, $hasError }) => utils.inputFocusStyle()({ theme, hasError: $hasError })};
`;
const TextInput = styled__default.default(uiPrimitives.Combobox.TextInput) `
  width: 100%;
  font-size: ${14 / 16}rem;
  color: ${({ theme }) => theme.colors.neutral800};
  padding: 0;
  border: none;
  background-color: transparent;

  &:focus-visible {
    outline: none;
  }

  &[aria-disabled='true'] {
    cursor: inherit;
  }
`;
const DownIcon = styled__default.default(uiPrimitives.Combobox.Icon) `
  & > svg {
    width: ${6 / 16}rem;

    & > path {
      fill: ${({ theme }) => theme.colors.neutral600};
    }
  }

  &[aria-disabled='true'] {
    cursor: inherit;
  }
`;
const Content = styled__default.default(uiPrimitives.Combobox.Content) `
  background: ${({ theme }) => theme.colors.neutral0};
  box-shadow: ${({ theme }) => theme.shadows.filterShadow};
  border: 1px solid ${({ theme }) => theme.colors.neutral150};
  border-radius: ${({ theme }) => theme.borderRadius};
  width: var(--radix-combobox-trigger-width);
  /* This is from the design-system figma file. */
  max-height: 15rem;
  z-index: ${({ theme }) => theme.zIndices[1]};
`;
const Viewport = styled__default.default(uiPrimitives.Combobox.Viewport) `
  padding: ${({ theme }) => theme.spaces[1]};
`;
const Option = React__namespace.forwardRef(({ children, value, disabled, textValue, ...props }, ref) => {
    return (jsxRuntime.jsx(uiPrimitives.Combobox.ComboboxItem, { asChild: true, value: value, disabled: disabled, textValue: textValue, children: jsxRuntime.jsx(OptionBox, { ref: ref, ...props, children: jsxRuntime.jsx(uiPrimitives.Combobox.ItemText, { asChild: true, children: jsxRuntime.jsx(Typography.Typography, { children: children }) }) }) }));
});
const OptionBox = styled__default.default.div `
  width: 100%;
  border: none;
  text-align: left;
  outline-offset: -3px;
  padding: ${({ theme }) => theme.spaces[2]} ${({ theme }) => theme.spaces[4]};
  background-color: ${({ theme }) => theme.colors.neutral0};
  border-radius: ${({ theme }) => theme.borderRadius};
  user-select: none;

  &[data-state='checked'] {
    background-color: ${({ theme }) => theme.colors.primary100};

    ${Typography.Typography} {
      color: ${({ theme }) => theme.colors.primary600};
      font-weight: bold;
    }
  }

  &:hover,
  &[data-highlighted] {
    outline: none;
    background-color: ${({ theme, $hasHover = true }) => ($hasHover ? theme.colors.primary100 : theme.colors.neutral0)};
  }

  &[data-highlighted] {
    ${Typography.Typography} {
      color: ${({ theme }) => theme.colors.primary600};
      font-weight: bold;
    }
  }
`;

exports.Combobox = Combobox;
exports.ComboboxInput = ComboboxInput;
exports.CreatableCombobox = CreatableCombobox;
exports.Option = Option;
exports.OptionBox = OptionBox;
