import { jsx, jsxs } from 'react/jsx-runtime';
import * as React from 'react';
import styled from 'styled-components';
import { useId } from '../hooks/useId.mjs';
import { useField } from '../Field/FieldContext.mjs';
import { Typography } from '../Typography/Typography.mjs';
import { BaseCheckbox } from '../BaseCheckbox/BaseCheckbox.mjs';
import { Field } from '../Field/Field.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Box } from '../Box/Box.mjs';
import { FieldHint } from '../Field/FieldHint.mjs';
import { FieldError } from '../Field/FieldError.mjs';

const CheckboxLabel = styled(Typography) `
  display: flex;
  align-items: flex-start;
  * {
    cursor: ${({ disabled }) => (disabled ? 'not-allowed' : 'pointer')};
  }
`;
const CheckboxTick = React.forwardRef((props, forwardedRef) => {
    const { id } = useField();
    return jsx(BaseCheckbox, { ref: forwardedRef, id: id, ...props });
});
const Checkbox = React.forwardRef(({ children, disabled = false, id, hint, error, ...props }, forwardedRef) => {
    const generatedId = useId(id);
    let ariaDescription;
    if (error) {
        ariaDescription = `${generatedId}-error`;
    }
    else if (hint) {
        ariaDescription = `${generatedId}-hint`;
    }
    return (jsx(Field, { id: generatedId, hint: hint, error: error, children: jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [jsxs(CheckboxLabel, { as: "label", textColor: "neutral800", disabled: disabled, children: [jsx(CheckboxTick, { ref: forwardedRef, disabled: disabled, "aria-describedby": ariaDescription, ...props }), jsx(Box, { paddingLeft: 2, children: children })] }), jsx(FieldHint, {}), jsx(FieldError, {})] }) }));
});

export { Checkbox };
