import { jsx, jsxs } from 'react/jsx-runtime';
import { forwardRef } from 'react';
import { Carousel } from './Carousel.mjs';
import { useId } from '../hooks/useId.mjs';
import { Field } from '../Field/Field.mjs';
import { FieldLabel } from '../Field/FieldLabel.mjs';
import { FieldHint } from '../Field/FieldHint.mjs';
import { FieldError } from '../Field/FieldError.mjs';
import { Flex } from '../Flex/Flex.mjs';

const CarouselInput = forwardRef(({ actions, children, error, hint, label, labelAction, nextLabel, onNext, onPrevious, previousLabel, required, secondaryLabel, selectedSlide, id, ...props }, forwardedRef) => {
    const generatedId = useId(id);
    return (jsx(Field, { hint: hint, error: error, id: generatedId, required: required, children: jsxs(Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label && jsx(FieldLabel, { action: labelAction, children: label }), jsx(Carousel, { ref: forwardedRef, actions: actions, label: label, nextLabel: nextLabel, onNext: onNext, onPrevious: onPrevious, previousLabel: previousLabel, secondaryLabel: secondaryLabel, selectedSlide: selectedSlide, id: generatedId, ...props, children: children }), jsx(FieldHint, {}), jsx(FieldError, {})] }) }));
});

export { CarouselInput };
