'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const Carousel = require('./Carousel.js');
const useId = require('../hooks/useId.js');
const Field = require('../Field/Field.js');
const FieldLabel = require('../Field/FieldLabel.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');
const Flex = require('../Flex/Flex.js');

const CarouselInput = React.forwardRef(({ actions, children, error, hint, label, labelAction, nextLabel, onNext, onPrevious, previousLabel, required, secondaryLabel, selectedSlide, id, ...props }, forwardedRef) => {
    const generatedId = useId.useId(id);
    return (jsxRuntime.jsx(Field.Field, { hint: hint, error: error, id: generatedId, required: required, children: jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [label && jsxRuntime.jsx(FieldLabel.FieldLabel, { action: labelAction, children: label }), jsxRuntime.jsx(Carousel.Carousel, { ref: forwardedRef, actions: actions, label: label, nextLabel: nextLabel, onNext: onNext, onPrevious: onPrevious, previousLabel: previousLabel, secondaryLabel: secondaryLabel, selectedSlide: selectedSlide, id: generatedId, ...props, children: children }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }));
});

exports.CarouselInput = CarouselInput;
