'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const utils = require('../Typography/utils.js');
const Box = require('../Box/Box.js');
const Tooltip = require('../Tooltip/Tooltip.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const StyledImage = styled__default.default(Box.Box) `
  ${utils.ellipsisStyle({ ellipsis: true })}
`;
const CarouselImage = (props) => {
    const [isError, setIsError] = React.useState(false);
    const handleImageError = () => {
        setIsError(true);
    };
    if (isError) {
        return (jsxRuntime.jsx(Tooltip.Tooltip, { description: props.alt ?? '', children: jsxRuntime.jsx(StyledImage, { as: "img", height: "100%", maxWidth: "100%", ...props }) }));
    }
    return jsxRuntime.jsx(StyledImage, { as: "img", height: "100%", maxWidth: "100%", ...props, onError: handleImageError });
};

exports.CarouselImage = CarouselImage;
