'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const keyboardKeys = require('../helpers/keyboardKeys.js');
const Tooltip = require('../Tooltip/Tooltip.js');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');
const Icon = require('../Icon/Icon.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const CarouselGrid = styled__default.default(Box.Box) `
  grid-template-columns: auto 1fr auto;
  grid-template-areas: 'startAction slides endAction';
`;
const CarouselSlides = styled__default.default(Flex.Flex) `
  grid-area: slides;
`;
const CarouselAction = styled__default.default(Box.Box) `
  grid-area: ${({ area }) => area};

  &:focus svg path,
  &:hover svg path {
    fill: ${({ theme }) => theme.colors.neutral900};
  }
`;
const Carousel = React__namespace.forwardRef(({ actions, children, label, nextLabel, onNext, onPrevious, previousLabel, secondaryLabel, selectedSlide, ...props }, forwardedRef) => {
    const prevActionRef = React__namespace.useRef(null);
    const nextActionRef = React__namespace.useRef(null);
    const childrenArray = React__namespace.Children.map(children, (node, index) => React__namespace.cloneElement(node, { selected: index === selectedSlide }));
    const handleKeyDown = (event) => {
        switch (event.key) {
            case keyboardKeys.KeyboardKeys.RIGHT: {
                event.preventDefault();
                if (nextActionRef?.current) {
                    nextActionRef.current.focus();
                }
                onNext();
                break;
            }
            case keyboardKeys.KeyboardKeys.LEFT: {
                event.preventDefault();
                if (prevActionRef?.current) {
                    prevActionRef.current.focus();
                }
                onPrevious();
                break;
            }
        }
    };
    return (jsxRuntime.jsx(Box.Box, { ref: forwardedRef, ...props, onKeyDown: handleKeyDown, children: jsxRuntime.jsxs(Box.Box, { padding: 2, borderColor: "neutral200", hasRadius: true, background: "neutral100", children: [jsxRuntime.jsxs(CarouselGrid, { as: "section", "aria-roledescription": "carousel", "aria-label": label, display: "grid", position: "relative", children: [childrenArray && childrenArray.length > 1 && (jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [jsxRuntime.jsx(CarouselAction, { as: "button", onClick: onPrevious, area: "startAction", ref: prevActionRef, "aria-label": previousLabel, type: "button", children: jsxRuntime.jsx(Icon.Icon, { as: icons.ChevronLeft, "aria-hidden": true, width: "6px", height: "10px", color: "neutral600" }) }), jsxRuntime.jsx(CarouselAction, { as: "button", onClick: onNext, area: "endAction", ref: nextActionRef, "aria-label": nextLabel, type: "button", children: jsxRuntime.jsx(Icon.Icon, { as: icons.ChevronRight, "aria-hidden": true, width: "6px", height: "10px", color: "neutral600" }) })] })), jsxRuntime.jsx(CarouselSlides, { "aria-live": "polite", paddingLeft: 2, paddingRight: 2, width: "100%", overflow: "hidden", children: childrenArray }), actions] }), secondaryLabel && (jsxRuntime.jsx(Box.Box, { paddingTop: 2, paddingLeft: 4, paddingRight: 4, children: jsxRuntime.jsx(Tooltip.Tooltip, { label: secondaryLabel, children: jsxRuntime.jsx(Flex.Flex, { justifyContent: "center", children: jsxRuntime.jsx(Typography.Typography, { variant: "pi", textColor: "neutral600", ellipsis: true, children: secondaryLabel }) }) }) }))] }) }));
});

exports.Carousel = Carousel;
