import { jsx } from 'react/jsx-runtime';
import { useCard } from './CardContext.mjs';
import { Typography } from '../Typography/Typography.mjs';

const CardTitle = (props) => {
    const { id } = useCard();
    return jsx(Typography, { variant: "pi", id: `${id}-title`, textColor: "neutral800", fontWeight: "bold", as: "div", ...props });
};
const CardSubtitle = (props) => {
    return jsx(Typography, { variant: "pi", ...props, textColor: "neutral600", as: "div" });
};

export { CardSubtitle, CardTitle };
