'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const CardContext = require('./CardContext.js');
const Typography = require('../Typography/Typography.js');

const CardTitle = (props) => {
    const { id } = CardContext.useCard();
    return jsxRuntime.jsx(Typography.Typography, { variant: "pi", id: `${id}-title`, textColor: "neutral800", fontWeight: "bold", as: "div", ...props });
};
const CardSubtitle = (props) => {
    return jsxRuntime.jsx(Typography.Typography, { variant: "pi", ...props, textColor: "neutral600", as: "div" });
};

exports.CardSubtitle = CardSubtitle;
exports.CardTitle = CardTitle;
