import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Flex } from '../Flex/Flex.mjs';

const CardAssetImg = styled.img `
  // inline flows is based on typography and displays an extra white space below the image
  // switch to block is required in order to make the img stick the bottom of the container
  // addition infos: https://stackoverflow.com/questions/5804256/image-inside-div-has-extra-space-below-the-image
  margin: 0;
  padding: 0;
  max-height: 100%;
  max-width: 100%;
  object-fit: contain;
`;
const sizes = {
    S: 88,
    M: 164,
};
const CardAssetWrapper = styled.div `
  display: flex;
  justify-content: center;
  height: ${({ size }) => sizes[size] / 16}rem;
  width: 100%;
  background: repeating-conic-gradient(${({ theme }) => theme.colors.neutral100} 0% 25%, transparent 0% 50%) 50% / 20px
    20px;
  border-top-left-radius: ${({ theme }) => theme.borderRadius};
  border-top-right-radius: ${({ theme }) => theme.borderRadius};
`;
const CardAsset = ({ size = 'M', children, ...props }) => {
    return (jsx(CardAssetWrapper, { size: size, children: children ? jsx(Flex, { children: children }) : jsx(CardAssetImg, { ...props, "aria-hidden": true }) }));
};

export { CardAsset };
