import styled from 'styled-components';
import { Stack } from '../Stack/Stack.mjs';

const CardAction = styled(Stack).attrs({
    horizontal: true,
    spacing: 2,
}) `
  position: absolute;
  top: ${({ theme }) => theme.spaces[3]};
  right: ${({ position, theme }) => {
    // @ts-expect-error styled-components can't overwrite the position prop from Stack
    if (position === 'end') {
        return theme.spaces[3];
    }
    return undefined;
}};
  left: ${({ position, theme }) => {
    // @ts-expect-error styled-components can't overwrite the position prop from Stack
    if (position === 'start') {
        return theme.spaces[3];
    }
    return undefined;
}};
`;

export { CardAction };
