'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const styled = require('styled-components');
const Stack = require('../Stack/Stack.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const CardAction = styled__default.default(Stack.Stack).attrs({
    horizontal: true,
    spacing: 2,
}) `
  position: absolute;
  top: ${({ theme }) => theme.spaces[3]};
  right: ${({ position, theme }) => {
    // @ts-expect-error styled-components can't overwrite the position prop from Stack
    if (position === 'end') {
        return theme.spaces[3];
    }
    return undefined;
}};
  left: ${({ position, theme }) => {
    // @ts-expect-error styled-components can't overwrite the position prop from Stack
    if (position === 'start') {
        return theme.spaces[3];
    }
    return undefined;
}};
`;

exports.CardAction = CardAction;
