import { jsx } from 'react/jsx-runtime';
import { useMemo } from 'react';
import { CardContext } from './CardContext.mjs';
import { useId } from '../hooks/useId.mjs';
import { Box } from '../Box/Box.mjs';

const Card = ({ id, ...props }) => {
    const generatedId = useId(id);
    const context = useMemo(() => ({ id: generatedId }), [generatedId]);
    return (jsx(CardContext.Provider, { value: context, children: jsx(Box, { id: id, tabIndex: 0, hasRadius: true, background: "neutral0", borderStyle: "solid", borderWidth: "1px", borderColor: "neutral150", shadow: "tableShadow", as: "article", "aria-labelledby": `${generatedId}-title`, ...props }) }));
};

export { Card };
