import { SUCCESS_LIGHT, DANGER_LIGHT, TERTIARY, DEFAULT, SECONDARY, VARIANTS, LIGHT_VARIANTS, GHOST, DANGER, SUCCESS } from './constants.mjs';
import { Typography } from '../Typography/Typography.mjs';

const getVariantColorName = (variant) => {
    if (variant === SUCCESS_LIGHT || variant === DANGER_LIGHT) {
        return `${variant.substring(0, variant.lastIndexOf('-'))}`;
    }
    if (variant === TERTIARY) {
        return 'neutral';
    }
    if (variant === DEFAULT || variant === SECONDARY || VARIANTS.every((vari) => vari !== variant)) {
        return 'primary';
    }
    // @ts-expect-error ghost is a variant, but ghostXXX is not any color...
    return `${variant}`;
};
const getDisabledStyle = ({ theme }) => {
    return `
    border: 1px solid ${theme.colors.neutral200};
    background: ${theme.colors.neutral150};
    ${Typography} {
      color: ${theme.colors.neutral600};
    }
    svg {
      > g, path {
        fill: ${theme.colors.neutral600};
      }
    }
  `;
};
const getHoverStyle = ({ theme, variant }) => {
    if ([...LIGHT_VARIANTS, SECONDARY].includes(variant)) {
        return `
      background-color: ${theme.colors.neutral0};
    `;
    }
    if (variant === TERTIARY) {
        return `
      background-color: ${theme.colors.neutral100};
    `;
    }
    if (variant === GHOST) {
        return `
      background-color: ${theme.colors.neutral100};
    `;
    }
    if (variant === DEFAULT) {
        return `
      border: 1px solid ${theme.colors.buttonPrimary500};
      background: ${theme.colors.buttonPrimary500};
    `;
    }
    return `
    border: 1px solid ${theme.colors[`${getVariantColorName(variant)}500`]};
    background: ${theme.colors[`${getVariantColorName(variant)}500`]};
  `;
};
const getActiveStyle = ({ theme, variant }) => {
    if ([...LIGHT_VARIANTS, SECONDARY].includes(variant)) {
        return `
      background-color: ${theme.colors.neutral0};
      border: 1px solid ${theme.colors[`${getVariantColorName(variant)}600`]};
      ${Typography} {
        color: ${theme.colors[`${getVariantColorName(variant)}600`]};
      }
      svg {
        > g, path {
          fill: ${theme.colors[`${getVariantColorName(variant)}600`]};
        }
      }
    `;
    }
    if (variant === TERTIARY) {
        return `
      background-color: ${theme.colors.neutral150};
    `;
    }
    return `
    border: 1px solid ${theme.colors[`${getVariantColorName(variant)}600`]};
    background: ${theme.colors[`${getVariantColorName(variant)}600`]};
  `;
};
const getVariantStyle = ({ theme, variant }) => {
    switch (variant) {
        case DANGER_LIGHT:
        case SUCCESS_LIGHT:
        case SECONDARY: {
            return `
          border: 1px solid ${theme.colors[`${getVariantColorName(variant)}200`]};
          background: ${theme.colors[`${getVariantColorName(variant)}100`]};
          ${Typography} {
            color: ${theme.colors[`${getVariantColorName(variant)}700`]};
          }
          svg {
            > g, path {
              fill: ${theme.colors[`${getVariantColorName(variant)}700`]};
            }
          }
        `;
        }
        case TERTIARY: {
            return `
          border: 1px solid ${theme.colors.neutral200};
          background: ${theme.colors.neutral0};
          ${Typography} {
            color: ${theme.colors.neutral800};
          }
          svg {
            > g, path {
              fill: ${theme.colors.neutral800};
            }
          }
        `;
        }
        case GHOST: {
            return `
        border: 1px solid transparent;
        background: transparent;

        ${Typography} {
          color: ${theme.colors.neutral800};
        }

        svg {
          > g, path {
            fill: ${theme.colors.neutral500};
          }
        }
      `;
        }
        case SUCCESS:
        case DANGER: {
            return `
          border: 1px solid ${theme.colors[`${getVariantColorName(variant)}600`]};
          background: ${theme.colors[`${getVariantColorName(variant)}600`]};
          ${Typography} {
            color: ${theme.colors.neutral0};
          }
        `;
        }
        default: {
            return `
          svg {
            > g, path {
              fill: ${theme.colors.buttonNeutral0};
            }
          }
        `;
        }
    }
};

export { getActiveStyle, getDisabledStyle, getHoverStyle, getVariantColorName, getVariantStyle };
