'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.js');
const Typography = require('../Typography/Typography.js');

const getVariantColorName = (variant) => {
    if (variant === constants.SUCCESS_LIGHT || variant === constants.DANGER_LIGHT) {
        return `${variant.substring(0, variant.lastIndexOf('-'))}`;
    }
    if (variant === constants.TERTIARY) {
        return 'neutral';
    }
    if (variant === constants.DEFAULT || variant === constants.SECONDARY || constants.VARIANTS.every((vari) => vari !== variant)) {
        return 'primary';
    }
    // @ts-expect-error ghost is a variant, but ghostXXX is not any color...
    return `${variant}`;
};
const getDisabledStyle = ({ theme }) => {
    return `
    border: 1px solid ${theme.colors.neutral200};
    background: ${theme.colors.neutral150};
    ${Typography.Typography} {
      color: ${theme.colors.neutral600};
    }
    svg {
      > g, path {
        fill: ${theme.colors.neutral600};
      }
    }
  `;
};
const getHoverStyle = ({ theme, variant }) => {
    if ([...constants.LIGHT_VARIANTS, constants.SECONDARY].includes(variant)) {
        return `
      background-color: ${theme.colors.neutral0};
    `;
    }
    if (variant === constants.TERTIARY) {
        return `
      background-color: ${theme.colors.neutral100};
    `;
    }
    if (variant === constants.GHOST) {
        return `
      background-color: ${theme.colors.neutral100};
    `;
    }
    if (variant === constants.DEFAULT) {
        return `
      border: 1px solid ${theme.colors.buttonPrimary500};
      background: ${theme.colors.buttonPrimary500};
    `;
    }
    return `
    border: 1px solid ${theme.colors[`${getVariantColorName(variant)}500`]};
    background: ${theme.colors[`${getVariantColorName(variant)}500`]};
  `;
};
const getActiveStyle = ({ theme, variant }) => {
    if ([...constants.LIGHT_VARIANTS, constants.SECONDARY].includes(variant)) {
        return `
      background-color: ${theme.colors.neutral0};
      border: 1px solid ${theme.colors[`${getVariantColorName(variant)}600`]};
      ${Typography.Typography} {
        color: ${theme.colors[`${getVariantColorName(variant)}600`]};
      }
      svg {
        > g, path {
          fill: ${theme.colors[`${getVariantColorName(variant)}600`]};
        }
      }
    `;
    }
    if (variant === constants.TERTIARY) {
        return `
      background-color: ${theme.colors.neutral150};
    `;
    }
    return `
    border: 1px solid ${theme.colors[`${getVariantColorName(variant)}600`]};
    background: ${theme.colors[`${getVariantColorName(variant)}600`]};
  `;
};
const getVariantStyle = ({ theme, variant }) => {
    switch (variant) {
        case constants.DANGER_LIGHT:
        case constants.SUCCESS_LIGHT:
        case constants.SECONDARY: {
            return `
          border: 1px solid ${theme.colors[`${getVariantColorName(variant)}200`]};
          background: ${theme.colors[`${getVariantColorName(variant)}100`]};
          ${Typography.Typography} {
            color: ${theme.colors[`${getVariantColorName(variant)}700`]};
          }
          svg {
            > g, path {
              fill: ${theme.colors[`${getVariantColorName(variant)}700`]};
            }
          }
        `;
        }
        case constants.TERTIARY: {
            return `
          border: 1px solid ${theme.colors.neutral200};
          background: ${theme.colors.neutral0};
          ${Typography.Typography} {
            color: ${theme.colors.neutral800};
          }
          svg {
            > g, path {
              fill: ${theme.colors.neutral800};
            }
          }
        `;
        }
        case constants.GHOST: {
            return `
        border: 1px solid transparent;
        background: transparent;

        ${Typography.Typography} {
          color: ${theme.colors.neutral800};
        }

        svg {
          > g, path {
            fill: ${theme.colors.neutral500};
          }
        }
      `;
        }
        case constants.SUCCESS:
        case constants.DANGER: {
            return `
          border: 1px solid ${theme.colors[`${getVariantColorName(variant)}600`]};
          background: ${theme.colors[`${getVariantColorName(variant)}600`]};
          ${Typography.Typography} {
            color: ${theme.colors.neutral0};
          }
        `;
        }
        default: {
            return `
          svg {
            > g, path {
              fill: ${theme.colors.buttonNeutral0};
            }
          }
        `;
        }
    }
};

exports.getActiveStyle = getActiveStyle;
exports.getDisabledStyle = getDisabledStyle;
exports.getHoverStyle = getHoverStyle;
exports.getVariantColorName = getVariantColorName;
exports.getVariantStyle = getVariantStyle;
