import { jsxs, jsx } from 'react/jsx-runtime';
import React__default from 'react';
import { Loader } from '@strapi/icons';
import styled, { keyframes } from 'styled-components';
import { DEFAULT, BUTTON_SIZES } from './constants.mjs';
import { getDisabledStyle, getHoverStyle, getActiveStyle, getVariantStyle } from './utils.mjs';
import { BaseButton } from '../BaseButton/BaseButton.mjs';
import { Box } from '../Box/Box.mjs';
import { Typography } from '../Typography/Typography.mjs';
import { Flex } from '../Flex/Flex.mjs';

const rotation = keyframes `
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(359deg);
  }
`;
const LoaderAnimated = styled(Loader) `
  animation: ${rotation} 2s infinite linear;
  will-change: transform;
`;
const ButtonWrapper = styled(BaseButton) `
  height: ${({ theme, size }) => theme.sizes.button[size]};

  svg {
    height: ${12 / 16}rem;
    width: auto;
  }

  &[aria-disabled='true'] {
    ${getDisabledStyle}

    &:active {
      ${getDisabledStyle}
    }
  }

  &:hover {
    ${getHoverStyle}
  }

  &:active {
    ${getActiveStyle}
  }

  ${getVariantStyle}
`;
const Button = React__default.forwardRef(({ variant = DEFAULT, startIcon, endIcon, disabled = false, children, onClick, size = BUTTON_SIZES[0], loading = false, fullWidth = false, ...props }, ref) => {
    const isDisabled = disabled || loading;
    const handleClick = (e) => {
        if (!isDisabled && onClick) {
            onClick(e);
        }
    };
    return (jsxs(ButtonWrapper, { ref: ref, "aria-disabled": isDisabled, disabled: isDisabled, size: size, variant: variant, onClick: handleClick, fullWidth: fullWidth, alignItems: "center", background: "buttonPrimary600", borderColor: "buttonPrimary600", gap: 2, inline: fullWidth, justifyContent: fullWidth ? 'center' : undefined, paddingLeft: 4, paddingRight: 4, width: fullWidth ? '100%' : undefined, ...props, children: [(startIcon || loading) && jsx(Box, { "aria-hidden": true, children: loading ? jsx(LoaderAnimated, {}) : startIcon }), jsx(Typography, { variant: size === 'S' ? 'pi' : undefined, fontWeight: "bold", textColor: "buttonNeutral0", children: children }), endIcon && jsx(Flex, { "aria-hidden": true, children: endIcon })] }));
});
Button.displayName = 'Button';

export { Button, ButtonWrapper };
