'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const constants = require('./constants.js');
const utils = require('./utils.js');
const BaseButton = require('../BaseButton/BaseButton.js');
const Box = require('../Box/Box.js');
const Typography = require('../Typography/Typography.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const rotation = styled.keyframes `
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(359deg);
  }
`;
const LoaderAnimated = styled__default.default(icons.Loader) `
  animation: ${rotation} 2s infinite linear;
  will-change: transform;
`;
const ButtonWrapper = styled__default.default(BaseButton.BaseButton) `
  height: ${({ theme, size }) => theme.sizes.button[size]};

  svg {
    height: ${12 / 16}rem;
    width: auto;
  }

  &[aria-disabled='true'] {
    ${utils.getDisabledStyle}

    &:active {
      ${utils.getDisabledStyle}
    }
  }

  &:hover {
    ${utils.getHoverStyle}
  }

  &:active {
    ${utils.getActiveStyle}
  }

  ${utils.getVariantStyle}
`;
const Button = React__default.default.forwardRef(({ variant = constants.DEFAULT, startIcon, endIcon, disabled = false, children, onClick, size = constants.BUTTON_SIZES[0], loading = false, fullWidth = false, ...props }, ref) => {
    const isDisabled = disabled || loading;
    const handleClick = (e) => {
        if (!isDisabled && onClick) {
            onClick(e);
        }
    };
    return (jsxRuntime.jsxs(ButtonWrapper, { ref: ref, "aria-disabled": isDisabled, disabled: isDisabled, size: size, variant: variant, onClick: handleClick, fullWidth: fullWidth, alignItems: "center", background: "buttonPrimary600", borderColor: "buttonPrimary600", gap: 2, inline: fullWidth, justifyContent: fullWidth ? 'center' : undefined, paddingLeft: 4, paddingRight: 4, width: fullWidth ? '100%' : undefined, ...props, children: [(startIcon || loading) && jsxRuntime.jsx(Box.Box, { "aria-hidden": true, children: loading ? jsxRuntime.jsx(LoaderAnimated, {}) : startIcon }), jsxRuntime.jsx(Typography.Typography, { variant: size === 'S' ? 'pi' : undefined, fontWeight: "bold", textColor: "buttonNeutral0", children: children }), endIcon && jsxRuntime.jsx(Flex.Flex, { "aria-hidden": true, children: endIcon })] }));
});
Button.displayName = 'Button';

exports.Button = Button;
exports.ButtonWrapper = ButtonWrapper;
