'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');
const Flex = require('../Flex/Flex.js');
const Box = require('../Box/Box.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const CrumbWrapper = styled__default.default(Flex.Flex) `
  svg {
    height: ${10 / 16}rem;
    width: ${10 / 16}rem;
    path {
      fill: ${({ theme }) => theme.colors.neutral500};
    }
  }
  :last-of-type ${Box.Box} {
    display: none;
  }
  :last-of-type ${Typography.Typography} {
    color: ${({ theme }) => theme.colors.neutral800};
    font-weight: ${({ theme }) => theme.fontWeights.bold};
  }
`;
const Crumb = ({ children }) => {
    return (jsxRuntime.jsxs(CrumbWrapper, { inline: true, as: "li", children: [jsxRuntime.jsx(Typography.Typography, { variant: "pi", textColor: "neutral600", children: children }), jsxRuntime.jsx(Box.Box, { "aria-hidden": true, paddingLeft: 3, paddingRight: 3, children: jsxRuntime.jsx(icons.ChevronRight, {}) })] }));
};
Crumb.displayName = 'Crumb';
const Breadcrumbs = ({ children, label, ...props }) => (jsxRuntime.jsxs(Flex.Flex, { ...props, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: label }), jsxRuntime.jsx("ol", { "aria-hidden": true, children: children })] }));
Breadcrumbs.displayName = 'Breadcrumbs';

exports.Breadcrumbs = Breadcrumbs;
exports.Crumb = Crumb;
