import styled from 'styled-components';
import handleResponsiveValues from '../helpers/handleResponsiveValues.mjs';
import { extractStyleFromTheme } from '../helpers/theme.mjs';

/**
 * Prevents these attributes from being spread on the DOM node
 */
const transientProps = {
    color: true,
    cursor: true,
    height: true,
    width: true,
};
const Box = styled.div.withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  // Font
  font-size: ${({ fontSize, theme }) => extractStyleFromTheme(theme.fontSizes, fontSize, fontSize)};

  // Colors
  background: ${({ theme, background }) => extractStyleFromTheme(theme.colors, background, background)};
  color: ${({ theme, color }) => extractStyleFromTheme(theme.colors, color, undefined)};

  // Spaces
  ${({ theme, padding }) => handleResponsiveValues('padding', padding, theme)}
  ${({ theme, paddingTop }) => handleResponsiveValues('padding-top', paddingTop, theme)}
  ${({ theme, paddingRight }) => handleResponsiveValues('padding-right', paddingRight, theme)}
  ${({ theme, paddingBottom }) => handleResponsiveValues('padding-bottom', paddingBottom, theme)}
  ${({ theme, paddingLeft }) => handleResponsiveValues('padding-left', paddingLeft, theme)}
  ${({ theme, marginLeft }) => handleResponsiveValues('margin-left', marginLeft, theme)}
  ${({ theme, marginRight }) => handleResponsiveValues('margin-right', marginRight, theme)}
  ${({ theme, marginTop }) => handleResponsiveValues('margin-top', marginTop, theme)}
  ${({ theme, marginBottom }) => handleResponsiveValues('margin-bottom', marginBottom, theme)}

  // Responsive hiding
  ${({ theme, hiddenS }) => (hiddenS ? `${theme.mediaQueries.tablet} { display: none; }` : undefined)}
  ${({ theme, hiddenXS }) => (hiddenXS ? `${theme.mediaQueries.mobile} { display: none; }` : undefined)}
  

  // Borders
  border-radius: ${({ theme, hasRadius, borderRadius }) => (hasRadius ? theme.borderRadius : borderRadius)};
  border-style: ${({ borderStyle }) => borderStyle};
  border-width: ${({ borderWidth }) => borderWidth};
  border-color: ${({ borderColor, theme }) => extractStyleFromTheme(theme.colors, borderColor, undefined)};
  border: ${({ theme, borderColor, borderStyle, borderWidth }) => {
    // This condition prevents borderColor from override the border-color attribute when not passing borderStyle nor borderWidth
    if (borderColor && !borderStyle && typeof borderWidth === 'undefined') {
        return `1px solid ${theme.colors[borderColor]}`;
    }
    // eslint-disable-next-line consistent-return
    return undefined;
}};

  // Shadows
  box-shadow: ${({ theme, shadow }) => extractStyleFromTheme(theme.shadows, shadow, undefined)};

  // Handlers
  pointer-events: ${({ pointerEvents }) => pointerEvents};
  &:hover {
    ${({ _hover, theme }) => (_hover ? _hover(theme) : undefined)}
  }

  // Display
  display: ${({ display }) => display};

  // Position
  position: ${({ position }) => position};
  left: ${({ left, theme }) => extractStyleFromTheme(theme.spaces, left, left)};
  right: ${({ right, theme }) => extractStyleFromTheme(theme.spaces, right, right)};
  top: ${({ top, theme }) => extractStyleFromTheme(theme.spaces, top, top)};
  bottom: ${({ bottom, theme }) => extractStyleFromTheme(theme.spaces, bottom, bottom)};
  z-index: ${({ zIndex }) => zIndex};
  overflow: ${({ overflow }) => overflow};

  // Size
  width: ${({ width, theme }) => extractStyleFromTheme(theme.spaces, width, width)};
  max-width: ${({ maxWidth, theme }) => extractStyleFromTheme(theme.spaces, maxWidth, maxWidth)};
  min-width: ${({ minWidth, theme }) => extractStyleFromTheme(theme.spaces, minWidth, minWidth)};
  height: ${({ height, theme }) => extractStyleFromTheme(theme.spaces, height, height)};
  max-height: ${({ maxHeight, theme }) => extractStyleFromTheme(theme.spaces, maxHeight, maxHeight)};
  min-height: ${({ minHeight, theme }) => extractStyleFromTheme(theme.spaces, minHeight, minHeight)};

  // Animation
  transition: ${({ transition }) => transition};
  transform: ${({ transform }) => transform};
  animation: ${({ animation }) => animation};

  //Flexbox children props
  flex-shrink: ${({ shrink }) => shrink};
  flex-grow: ${({ grow }) => grow};
  flex-basis: ${({ basis }) => basis};
  flex: ${({ flex }) => flex};

  // Text
  text-align: ${({ textAlign }) => textAlign};
  text-transform: ${({ textTransform }) => textTransform};
  line-height: ${({ theme, lineHeight }) => extractStyleFromTheme(theme.lineHeights, lineHeight, lineHeight)};

  // Cursor
  cursor: ${({ cursor }) => cursor};
`;

export { Box };
