'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const styled = require('styled-components');
const handleResponsiveValues = require('../helpers/handleResponsiveValues.js');
const theme = require('../helpers/theme.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

/**
 * Prevents these attributes from being spread on the DOM node
 */
const transientProps = {
    color: true,
    cursor: true,
    height: true,
    width: true,
};
const Box = styled__default.default.div.withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  // Font
  font-size: ${({ fontSize, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.fontSizes, fontSize, fontSize)};

  // Colors
  background: ${({ theme: theme$1, background }) => theme.extractStyleFromTheme(theme$1.colors, background, background)};
  color: ${({ theme: theme$1, color }) => theme.extractStyleFromTheme(theme$1.colors, color, undefined)};

  // Spaces
  ${({ theme, padding }) => handleResponsiveValues('padding', padding, theme)}
  ${({ theme, paddingTop }) => handleResponsiveValues('padding-top', paddingTop, theme)}
  ${({ theme, paddingRight }) => handleResponsiveValues('padding-right', paddingRight, theme)}
  ${({ theme, paddingBottom }) => handleResponsiveValues('padding-bottom', paddingBottom, theme)}
  ${({ theme, paddingLeft }) => handleResponsiveValues('padding-left', paddingLeft, theme)}
  ${({ theme, marginLeft }) => handleResponsiveValues('margin-left', marginLeft, theme)}
  ${({ theme, marginRight }) => handleResponsiveValues('margin-right', marginRight, theme)}
  ${({ theme, marginTop }) => handleResponsiveValues('margin-top', marginTop, theme)}
  ${({ theme, marginBottom }) => handleResponsiveValues('margin-bottom', marginBottom, theme)}

  // Responsive hiding
  ${({ theme, hiddenS }) => (hiddenS ? `${theme.mediaQueries.tablet} { display: none; }` : undefined)}
  ${({ theme, hiddenXS }) => (hiddenXS ? `${theme.mediaQueries.mobile} { display: none; }` : undefined)}
  

  // Borders
  border-radius: ${({ theme, hasRadius, borderRadius }) => (hasRadius ? theme.borderRadius : borderRadius)};
  border-style: ${({ borderStyle }) => borderStyle};
  border-width: ${({ borderWidth }) => borderWidth};
  border-color: ${({ borderColor, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.colors, borderColor, undefined)};
  border: ${({ theme, borderColor, borderStyle, borderWidth }) => {
    // This condition prevents borderColor from override the border-color attribute when not passing borderStyle nor borderWidth
    if (borderColor && !borderStyle && typeof borderWidth === 'undefined') {
        return `1px solid ${theme.colors[borderColor]}`;
    }
    // eslint-disable-next-line consistent-return
    return undefined;
}};

  // Shadows
  box-shadow: ${({ theme: theme$1, shadow }) => theme.extractStyleFromTheme(theme$1.shadows, shadow, undefined)};

  // Handlers
  pointer-events: ${({ pointerEvents }) => pointerEvents};
  &:hover {
    ${({ _hover, theme }) => (_hover ? _hover(theme) : undefined)}
  }

  // Display
  display: ${({ display }) => display};

  // Position
  position: ${({ position }) => position};
  left: ${({ left, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.spaces, left, left)};
  right: ${({ right, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.spaces, right, right)};
  top: ${({ top, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.spaces, top, top)};
  bottom: ${({ bottom, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.spaces, bottom, bottom)};
  z-index: ${({ zIndex }) => zIndex};
  overflow: ${({ overflow }) => overflow};

  // Size
  width: ${({ width, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.spaces, width, width)};
  max-width: ${({ maxWidth, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.spaces, maxWidth, maxWidth)};
  min-width: ${({ minWidth, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.spaces, minWidth, minWidth)};
  height: ${({ height, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.spaces, height, height)};
  max-height: ${({ maxHeight, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.spaces, maxHeight, maxHeight)};
  min-height: ${({ minHeight, theme: theme$1 }) => theme.extractStyleFromTheme(theme$1.spaces, minHeight, minHeight)};

  // Animation
  transition: ${({ transition }) => transition};
  transform: ${({ transform }) => transform};
  animation: ${({ animation }) => animation};

  //Flexbox children props
  flex-shrink: ${({ shrink }) => shrink};
  flex-grow: ${({ grow }) => grow};
  flex-basis: ${({ basis }) => basis};
  flex: ${({ flex }) => flex};

  // Text
  text-align: ${({ textAlign }) => textAlign};
  text-transform: ${({ textTransform }) => textTransform};
  line-height: ${({ theme: theme$1, lineHeight }) => theme.extractStyleFromTheme(theme$1.lineHeights, lineHeight, lineHeight)};

  // Cursor
  cursor: ${({ cursor }) => cursor};
`;

exports.Box = Box;
