'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const context = require('./context.js');
const setTabIndexOnFirstItem = require('../helpers/setTabIndexOnFirstItem.js');

const RadioGroup = ({ children, labelledBy, onChange, value = '', size = 'M', name, ...props }) => {
    const radioGroupRef = React.useRef(null);
    React.useLayoutEffect(() => {
        if (!value) {
            setTabIndexOnFirstItem.setTabIndexOnFirstItem(radioGroupRef.current, `[name="${name}"]`);
        }
    }, [value, name]);
    const context$1 = React.useMemo(() => ({ onChange, selected: value, name, size }), [name, onChange, size, value]);
    return (jsxRuntime.jsx(context.RadioContext.Provider, { value: context$1, children: jsxRuntime.jsx("div", { ref: radioGroupRef, role: "radiogroup", "aria-labelledby": labelledBy, ...props, children: children }) }));
};

exports.RadioGroup = RadioGroup;
