import { jsx } from 'react/jsx-runtime';
import * as React from 'react';
import styled from 'styled-components';
import checkmarkIconDisabled from './assets/checkmark-black.svg.mjs';
import checkmarkIcon from './assets/checkmark.svg.mjs';
import { getCheckboxSize } from './utils.mjs';
import { useComposedRefs } from '../hooks/useComposeRefs.mjs';
import { Box } from '../Box/Box.mjs';

const CheckboxInput = styled.input `
  height: ${getCheckboxSize};
  min-width: ${getCheckboxSize};
  margin: 0;
  border-radius: ${({ theme }) => theme.borderRadius};
  border: 1px solid ${({ theme }) => theme.colors.neutral300};
  -webkit-appearance: none;
  background-color: ${({ theme }) => theme.colors.neutral0};
  cursor: pointer;

  &:checked {
    background-color: ${({ theme }) => theme.colors.primary600};
    border: 1px solid ${({ theme }) => theme.colors.primary600};

    &:after {
      content: '';
      display: block;
      position: relative;
      background: ${() => `url("${checkmarkIcon}") no-repeat no-repeat center center`};
      width: 10px;
      height: 10px;
      left: 50%;
      top: 50%;
      transform: translateX(-50%) translateY(-50%);
    }

    &:disabled:after {
      background: ${() => `url("${checkmarkIconDisabled}") no-repeat no-repeat center center`};
    }
  }

  &:disabled {
    background-color: ${({ theme }) => theme.colors.neutral200};
    border: 1px solid ${({ theme }) => theme.colors.neutral300};
  }

  &:indeterminate {
    background-color: ${({ theme }) => theme.colors.primary600};
    border: 1px solid ${({ theme }) => theme.colors.primary600};

    &:after {
      content: '';
      display: block;
      position: relative;
      color: white;
      height: 2px;
      width: 10px;
      background-color: ${({ theme }) => theme.colors.neutral0};
      left: 50%;
      top: 50%;
      transform: translateX(-50%) translateY(-50%);
    }

    &:disabled {
      background-color: ${({ theme }) => theme.colors.neutral200};
      border: 1px solid ${({ theme }) => theme.colors.neutral300};
      &:after {
        background-color: ${({ theme }) => theme.colors.neutral500};
      }
    }
  }
`;
const BaseCheckbox = React.forwardRef(({ indeterminate = false, size = 'M', name, value = false, onValueChange, ...inputProps }, forwardedRef) => {
    const checkboxRef = React.useRef(null);
    const composedRefs = useComposedRefs(checkboxRef, forwardedRef);
    React.useEffect(() => {
        if (checkboxRef.current && indeterminate) {
            checkboxRef.current.indeterminate = indeterminate;
        }
        else {
            checkboxRef.current.indeterminate = false;
        }
    }, [indeterminate]);
    const handleValueChange = () => {
        if (onValueChange) {
            onValueChange(!value);
        }
    };
    return (jsx(Box, { children: jsx(CheckboxInput, { size: size, checked: value, onChange: handleValueChange, type: "checkbox", ref: composedRefs, name: name, ...inputProps }) }));
});
BaseCheckbox.displayName = 'BaseCheckbox';

export { BaseCheckbox };
