import { jsx } from 'react/jsx-runtime';
import * as React from 'react';
import styled from 'styled-components';
import { buttonFocusStyle } from '../themes/utils.mjs';
import { Flex } from '../Flex/Flex.mjs';

const BaseButtonWrapper = styled(Flex) `
  > svg {
    height: ${({ theme }) => theme.spaces[3]};
    width: ${({ theme }) => theme.spaces[3]};

    > g,
    path {
      fill: ${({ theme }) => theme.colors.neutral0};
    }
  }

  &[aria-disabled='true'] {
    pointer-events: none;
  }

  ${buttonFocusStyle}
`;
const BaseButton = React.forwardRef(({ disabled, children, background = 'neutral0', ...props }, ref) => {
    return (jsx(BaseButtonWrapper, { ref: ref, "aria-disabled": disabled, as: "button", type: "button", disabled: disabled, padding: 2, hasRadius: true, background: background, borderColor: "neutral200", cursor: "pointer", ...props, children: children }));
});
BaseButton.displayName = 'BaseButton';

export { BaseButton, BaseButtonWrapper };
