'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const utils = require('../themes/utils.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const BaseButtonWrapper = styled__default.default(Flex.Flex) `
  > svg {
    height: ${({ theme }) => theme.spaces[3]};
    width: ${({ theme }) => theme.spaces[3]};

    > g,
    path {
      fill: ${({ theme }) => theme.colors.neutral0};
    }
  }

  &[aria-disabled='true'] {
    pointer-events: none;
  }

  ${utils.buttonFocusStyle}
`;
const BaseButton = React__namespace.forwardRef(({ disabled, children, background = 'neutral0', ...props }, ref) => {
    return (jsxRuntime.jsx(BaseButtonWrapper, { ref: ref, "aria-disabled": disabled, as: "button", type: "button", disabled: disabled, padding: 2, hasRadius: true, background: background, borderColor: "neutral200", cursor: "pointer", ...props, children: children }));
});
BaseButton.displayName = 'BaseButton';

exports.BaseButton = BaseButton;
exports.BaseButtonWrapper = BaseButtonWrapper;
