import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const Base = styled(Flex) `
  border-radius: ${({ theme, size }) => (size === 'S' ? '2px' : theme.borderRadius)};
  height: ${({ size, theme }) => theme.sizes.badge[size]};
`;
const Badge = ({ active = false, size = 'M', textColor = 'neutral600', backgroundColor = 'neutral150', children, minWidth = 5, ...props }) => {
    const paddingX = size === 'S' ? 1 : 2;
    return (jsx(Base, { inline: true, alignItem: "center", justifyContent: "center", minWidth: minWidth, paddingLeft: paddingX, paddingRight: paddingX, background: active ? 'primary200' : backgroundColor, size: size, ...props, children: jsx(Typography, { variant: "sigma", textColor: active ? 'primary600' : textColor, children: children }) }));
};

export { Badge };
