'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const Base = styled__default.default(Flex.Flex) `
  border-radius: ${({ theme, size }) => (size === 'S' ? '2px' : theme.borderRadius)};
  height: ${({ size, theme }) => theme.sizes.badge[size]};
`;
const Badge = ({ active = false, size = 'M', textColor = 'neutral600', backgroundColor = 'neutral150', children, minWidth = 5, ...props }) => {
    const paddingX = size === 'S' ? 1 : 2;
    return (jsxRuntime.jsx(Base, { inline: true, alignItem: "center", justifyContent: "center", minWidth: minWidth, paddingLeft: paddingX, paddingRight: paddingX, background: active ? 'primary200' : backgroundColor, size: size, ...props, children: jsxRuntime.jsx(Typography.Typography, { variant: "sigma", textColor: active ? 'primary600' : textColor, children: children }) }));
};

exports.Badge = Badge;
