import { jsxs, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import styled from 'styled-components';
import { previewSize, avatarSize } from './constants.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const AvatarImg = styled.img `
  border-radius: 50%;
  object-fit: cover;
  display: block;
  position: relative;
`;
const PreviewContainer = styled.img `
  border-radius: 50%;
  object-fit: cover;
  position: absolute;
  transform: translate(-${(previewSize - avatarSize) / 2}px, -100%);
  margin-top: -${({ theme }) => theme.spaces[1]};
`;
const Overlay = styled(Box) `
  opacity: 0.4;
`;
const Avatar = ({ src, alt, preview }) => {
    const [previewVisible, setPreviewVisible] = React.useState(false);
    const isHovering = Boolean(preview && previewVisible);
    return (jsxs("span", { children: [isHovering ? (jsx(PreviewContainer, { "aria-hidden": true, alt: "", width: `${previewSize}px`, height: `${previewSize}px`, 
                // eslint-disable-next-line no-nested-ternary
                src: preview === true ? src : typeof preview === 'string' ? preview : '' })) : null, jsxs(Box, { zIndex: isHovering ? 1 : undefined, position: "relative", onMouseEnter: () => setPreviewVisible(true), onMouseLeave: () => setPreviewVisible(false), width: `${avatarSize}px`, height: `${avatarSize}px`, children: [isHovering ? (jsx(Overlay, { background: "neutral0", borderRadius: "50%", position: "absolute", width: `${avatarSize}px`, height: `${avatarSize}px`, zIndex: 1 })) : null, jsx(AvatarImg, { src: src, alt: alt, width: `${avatarSize}px`, height: `${avatarSize}px` })] })] }));
};
const InitialsWrapper = styled(Flex) `
  span {
    line-height: 0;
  }
`;
const Initials = ({ children, background = 'primary600', textColor = 'buttonNeutral0' }) => {
    return (jsx(InitialsWrapper, { background: background, borderRadius: "50%", width: `${avatarSize}px`, height: `${avatarSize}px`, justifyContent: "center", children: jsx(Typography, { fontSize: 0, fontWeight: "bold", textColor: textColor, textTransform: "uppercase", children: children }) }));
};

export { Avatar, Initials };
