'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const constants = require('./constants.js');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const AvatarImg = styled__default.default.img `
  border-radius: 50%;
  object-fit: cover;
  display: block;
  position: relative;
`;
const PreviewContainer = styled__default.default.img `
  border-radius: 50%;
  object-fit: cover;
  position: absolute;
  transform: translate(-${(constants.previewSize - constants.avatarSize) / 2}px, -100%);
  margin-top: -${({ theme }) => theme.spaces[1]};
`;
const Overlay = styled__default.default(Box.Box) `
  opacity: 0.4;
`;
const Avatar = ({ src, alt, preview }) => {
    const [previewVisible, setPreviewVisible] = React__namespace.useState(false);
    const isHovering = Boolean(preview && previewVisible);
    return (jsxRuntime.jsxs("span", { children: [isHovering ? (jsxRuntime.jsx(PreviewContainer, { "aria-hidden": true, alt: "", width: `${constants.previewSize}px`, height: `${constants.previewSize}px`, 
                // eslint-disable-next-line no-nested-ternary
                src: preview === true ? src : typeof preview === 'string' ? preview : '' })) : null, jsxRuntime.jsxs(Box.Box, { zIndex: isHovering ? 1 : undefined, position: "relative", onMouseEnter: () => setPreviewVisible(true), onMouseLeave: () => setPreviewVisible(false), width: `${constants.avatarSize}px`, height: `${constants.avatarSize}px`, children: [isHovering ? (jsxRuntime.jsx(Overlay, { background: "neutral0", borderRadius: "50%", position: "absolute", width: `${constants.avatarSize}px`, height: `${constants.avatarSize}px`, zIndex: 1 })) : null, jsxRuntime.jsx(AvatarImg, { src: src, alt: alt, width: `${constants.avatarSize}px`, height: `${constants.avatarSize}px` })] })] }));
};
const InitialsWrapper = styled__default.default(Flex.Flex) `
  span {
    line-height: 0;
  }
`;
const Initials = ({ children, background = 'primary600', textColor = 'buttonNeutral0' }) => {
    return (jsxRuntime.jsx(InitialsWrapper, { background: background, borderRadius: "50%", width: `${constants.avatarSize}px`, height: `${constants.avatarSize}px`, justifyContent: "center", children: jsxRuntime.jsx(Typography.Typography, { fontSize: 0, fontWeight: "bold", textColor: textColor, textTransform: "uppercase", children: children }) }));
};

exports.Avatar = Avatar;
exports.Initials = Initials;
