'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const handleBackgroundColor = (variant) => {
    switch (variant) {
        case 'danger':
            return 'danger100';
        case 'success':
            return 'success100';
        case 'warning':
            return 'warning100';
        default:
            return 'primary100';
    }
};
// border-color is always 1 shade darker than background-color
const handleBorderColor = (variant) => {
    return handleBackgroundColor(variant).replace('100', '200');
};
const handleIconColor = ({ theme, variant }) => {
    if (variant === 'danger') {
        return theme.colors.danger700;
    }
    if (variant === 'success') {
        return theme.colors.success700;
    }
    if (variant === 'warning') {
        return theme.colors.warning700;
    }
    return theme.colors.primary700;
};

exports.handleBackgroundColor = handleBackgroundColor;
exports.handleBorderColor = handleBorderColor;
exports.handleIconColor = handleIconColor;
