'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const utils$1 = require('./utils.js');
const utils = require('../themes/utils.js');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const CloseButton = styled__default.default(Box.Box) `
  svg {
    height: 100%;
    width: 100%;

    path {
      fill: ${({ theme }) => theme.colors.neutral700};
    }
  }

  ${utils.buttonFocusStyle};
`;
const AlertIconWrapper = styled__default.default(Flex.Flex) `
  svg {
    height: 100%;
    width: 100%;

    path {
      fill: ${utils$1.handleIconColor};
    }
  }
`;
const AlertIcon = ({ variant, ...props }) => {
    if (variant === 'success') {
        return jsxRuntime.jsx(icons.CheckCircle, { ...props });
    }
    if (variant === 'danger' || variant === 'warning') {
        return jsxRuntime.jsx(icons.ExclamationMarkCircle, { ...props });
    }
    return jsxRuntime.jsx(icons.Information, { ...props });
};
const ActionBox = styled__default.default(Box.Box) `
  & a > span {
    color: ${utils$1.handleIconColor};
  }

  svg path {
    fill: ${utils$1.handleIconColor};
  }
`;
const Alert = ({ title, children, variant = 'default', onClose, closeLabel, titleAs = 'p', action, ...props }) => {
    return (jsxRuntime.jsxs(Flex.Flex, { alignItems: "flex-start", background: utils$1.handleBackgroundColor(variant), borderColor: utils$1.handleBorderColor(variant), boxShadow: "filterShadow", gap: 3, hasRadius: true, padding: 5, paddingRight: 6, variant: variant, ...props, children: [jsxRuntime.jsx(AlertIconWrapper, { height: `${20 / 16}rem`, shrink: 0, variant: variant, width: `${20 / 16}rem`, children: jsxRuntime.jsx(AlertIcon, { "aria-hidden": true, variant: variant }) }), jsxRuntime.jsxs(Flex.Flex, { alignItems: "start", gap: action ? 2 : 1, wrap: "wrap", role: variant === 'danger' ? 'alert' : 'status', width: "100%", children: [title && (jsxRuntime.jsx(Typography.Typography, { fontWeight: "bold", textColor: "neutral800", as: titleAs, children: title })), jsxRuntime.jsx(Typography.Typography, { as: "p", textColor: "neutral800", children: children }), action && jsxRuntime.jsx(ActionBox, { variant: variant, children: action })] }), jsxRuntime.jsx(CloseButton, { as: "button", background: "transparent", borderColor: undefined, height: `${12 / 16}rem`, marginTop: 1, onClick: onClose, width: `${12 / 16}rem`, "aria-label": closeLabel, children: jsxRuntime.jsx(icons.Cross, { "aria-hidden": true }) })] }));
};

exports.Alert = Alert;
