import { jsxs, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import styled from 'styled-components';
import { KeyboardNavigable } from '../KeyboardNavigable/KeyboardNavigable.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const AccordionFooter = styled(Box) `
  border-bottom: 1px solid ${({ theme }) => theme.colors.neutral200};
  border-right: 1px solid ${({ theme }) => theme.colors.neutral200};
  border-left: 1px solid ${({ theme }) => theme.colors.neutral200};
  border-radius: 0 0 ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius};
`;
const EnhancedGroup = styled(Box) `
  & > * {
    & > * {
      border-radius: unset;
    }
  }

  & > * {
    border-radius: unset;
    border-right: 1px solid ${({ theme }) => theme.colors.neutral200};
    border-left: 1px solid ${({ theme }) => theme.colors.neutral200};
    border-bottom: 1px solid ${({ theme }) => theme.colors.neutral200};
  }

  & > *:first-of-type {
    border-top: 1px solid ${({ theme }) => theme.colors.neutral200};
    border-radius: ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius} 0 0;
    & > * {
      border-radius: ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius} 0 0;
    }

    &:hover {
      border-top: 1px solid ${({ theme }) => theme.colors.primary600};
    }
  }

  & [data-strapi-expanded='true'] {
    border: 1px solid ${({ theme }) => theme.colors.primary600};
  }

  ${({ theme, footer }) => `
    &:not(${footer}) {
      & > *:last-of-type {
        border-radius: 0 0 ${theme.borderRadius} ${theme.borderRadius};
      }
    }
  `}
`;
const LabelAction = styled(Box) `
  svg path {
    fill: ${({ theme }) => theme.colors.neutral500};
  }
`;
const AccordionGroup = ({ children, footer, label, labelAction, error }) => {
    const childrenArray = React.Children.toArray(children).map((child) => {
        return React.cloneElement(child, { hasErrorMessage: false });
    });
    return (jsxs(KeyboardNavigable, { attributeName: "data-strapi-accordion-toggle", children: [label && (jsxs(Flex, { paddingBottom: 1, children: [jsx(Typography, { variant: "pi", as: "label", textColor: "neutral800", fontWeight: "bold", children: label }), labelAction && jsx(LabelAction, { paddingLeft: 1, children: labelAction })] })), jsx(EnhancedGroup, { footer: footer, children: childrenArray }), footer && jsx(AccordionFooter, { children: footer }), error && (jsx(Box, { paddingTop: 1, children: jsx(Typography, { variant: "pi", textColor: "danger600", children: error }) }))] }));
};

export { AccordionGroup };
