'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const AccordionContext = require('./AccordionContext.js');
const useId = require('../hooks/useId.js');
const Typography = require('../Typography/Typography.js');
const Flex = require('../Flex/Flex.js');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const getBorder = ({ theme, expanded, variant, disabled, error }) => {
    if (error) {
        return `1px solid ${theme.colors.danger600} !important`;
    }
    if (disabled) {
        return `1px solid ${theme.colors.neutral150}`;
    }
    if (expanded) {
        return `1px solid ${theme.colors.primary600}`;
    }
    if (variant === 'primary') {
        return `1px solid ${theme.colors.neutral0}`;
    }
    return `1px solid ${theme.colors.neutral100}`;
};
const AccordionTypography = styled__default.default(Typography.Typography) ``;
const AccordionWrapper = styled__default.default(Box.Box) `
  border: ${getBorder};

  &:hover:not([aria-disabled='true']) {
    border: 1px solid ${({ theme }) => theme.colors.primary600};

    ${AccordionTypography} {
      color: ${({ theme, expanded }) => (expanded ? undefined : theme.colors.primary700)};
    }

    ${Typography.Typography} {
      color: ${({ theme, expanded }) => (expanded ? undefined : theme.colors.primary600)};
    }

    & > ${Flex.Flex} {
      background: ${({ theme }) => theme.colors.primary100};
    }

    [data-strapi-dropdown='true'] {
      background: ${({ theme }) => theme.colors.primary200};
    }
  }
`;
const Accordion = ({ children, disabled = false, error, expanded = false, hasErrorMessage = true, id, onToggle, toggle, size = 'M', variant = 'primary', shadow, }) => {
    const generatedId = useId.useId(id);
    const context = React__namespace.useMemo(() => ({ expanded, onToggle, toggle, id: generatedId, size, variant, disabled }), [disabled, expanded, generatedId, onToggle, size, toggle, variant]);
    return (jsxRuntime.jsxs(AccordionContext.AccordionContext.Provider, { value: context, children: [jsxRuntime.jsx(AccordionWrapper, { "data-strapi-expanded": expanded, disabled: disabled, "aria-disabled": disabled, expanded: expanded, hasRadius: true, variant: variant, error: error, shadow: shadow, children: children }), error && hasErrorMessage && (jsxRuntime.jsx(Box.Box, { paddingTop: 1, children: jsxRuntime.jsx(Typography.Typography, { variant: "pi", textColor: "danger600", children: error }) }))] }));
};

exports.Accordion = Accordion;
exports.AccordionTypography = AccordionTypography;
