import type { Knex } from 'knex';
import * as helpers from './helpers';
import type { Join } from './helpers/join';
import type { Database } from '..';
interface State {
    type: 'select' | 'insert' | 'update' | 'delete' | 'count' | 'max' | 'truncate';
    select: Array<string | Knex.Raw>;
    count: string | null;
    max: string | null;
    first: boolean;
    data: Record<string, unknown> | (null | Record<string, unknown>)[] | null;
    where: Record<string, unknown>[];
    joins: Join[];
    populate: object | null;
    limit: number | null;
    offset: number | null;
    transaction: any;
    forUpdate: boolean;
    onConflict: any;
    merge: any;
    ignore: boolean;
    orderBy: any[];
    groupBy: any[];
    increments: any[];
    decrements: any[];
    aliasCounter: number;
    filters: any;
    search: string;
}
export interface QueryBuilder {
    alias: string;
    state: State;
    getAlias(): string;
    clone(): QueryBuilder;
    select(args: string | Array<string | Knex.Raw>): QueryBuilder;
    addSelect(args: string | string[]): QueryBuilder;
    insert<TData extends Record<string, unknown> | Record<string, unknown>[]>(data: TData): QueryBuilder;
    onConflict(args: any): QueryBuilder;
    merge(args: any): QueryBuilder;
    ignore(): QueryBuilder;
    delete(): QueryBuilder;
    ref(name: string): any;
    update<TData extends Record<string, unknown>>(data: TData): QueryBuilder;
    increment(column: string, amount?: number): QueryBuilder;
    decrement(column: string, amount?: number): QueryBuilder;
    count(count?: string): QueryBuilder;
    max(column: string): QueryBuilder;
    where(where?: object): QueryBuilder;
    limit(limit: number): QueryBuilder;
    offset(offset: number): QueryBuilder;
    orderBy(orderBy: any): QueryBuilder;
    groupBy(groupBy: any): QueryBuilder;
    populate(populate: any): QueryBuilder;
    search(query: string): QueryBuilder;
    transacting(transaction: any): QueryBuilder;
    forUpdate(): QueryBuilder;
    init(params?: any): QueryBuilder;
    filters(filters: any): void;
    first(): QueryBuilder;
    join(join: any): QueryBuilder;
    mustUseAlias(): boolean;
    aliasColumn(key: any, alias?: string): any;
    raw: Knex.RawBuilder;
    shouldUseSubQuery(): boolean;
    runSubQuery(): any;
    processState(): void;
    shouldUseDistinct(): boolean;
    processSelect(): void;
    getKnexQuery(): Knex.QueryBuilder;
    execute<T>(options?: {
        mapResults?: boolean;
    }): Promise<T>;
    stream(options?: {
        mapResults?: boolean;
    }): helpers.ReadableQuery;
}
declare const createQueryBuilder: (uid: string, db: Database, initialState?: Partial<State>) => QueryBuilder;
export default createQueryBuilder;
//# sourceMappingURL=query-builder.d.ts.map