/// <reference types="lodash" />
/// <reference types="node" />
import type { Readable } from 'stream';
import type { Schema } from '@strapi/types';
import type { IMetadata, ISourceProvider, ProviderType } from '../../../../types';
/**
 * Provider options
 */
export interface ILocalFileSourceProviderOptions {
    file: {
        path: string;
    };
    encryption: {
        enabled: boolean;
        key?: string;
    };
    compression: {
        enabled: boolean;
    };
}
export declare const createLocalFileSourceProvider: (options: ILocalFileSourceProviderOptions) => LocalFileSourceProvider;
declare class LocalFileSourceProvider implements ISourceProvider {
    #private;
    type: ProviderType;
    name: string;
    options: ILocalFileSourceProviderOptions;
    constructor(options: ILocalFileSourceProviderOptions);
    /**
     * Pre flight checks regarding the provided options, making sure that the file can be opened (decrypted, decompressed), etc.
     */
    bootstrap(): Promise<void>;
    getMetadata(): Promise<IMetadata | null>;
    getSchemas(): Promise<import("lodash").Dictionary<Schema.Schema>>;
    createEntitiesReadStream(): Readable;
    createSchemasReadStream(): Readable;
    createLinksReadStream(): Readable;
    createConfigurationReadStream(): Readable;
    createAssetsReadStream(): Readable | Promise<Readable>;
}
export {};
//# sourceMappingURL=index.d.ts.map