import { type AxiosResponse } from 'axios';
import type { CLIContext, CloudCliConfig } from '../types';
export declare const VERSION = "v1";
export type ProjectInfos = {
    name: string;
    nodeVersion: string;
    region: string;
    plan?: string;
    url?: string;
};
export type ProjectInput = Omit<ProjectInfos, 'id'>;
export type DeployResponse = {
    build_id: string;
    image: string;
};
export type TrackPayload = Record<string, unknown>;
export interface CloudApiService {
    deploy(deployInput: {
        filePath: string;
        project: {
            name: string;
        };
    }, { onUploadProgress, }: {
        onUploadProgress: (progressEvent: {
            loaded: number;
            total?: number;
        }) => void;
    }): Promise<AxiosResponse<DeployResponse>>;
    createProject(projectInput: ProjectInput): Promise<{
        data: ProjectInfos;
        status: number;
    }>;
    getUserInfo(): Promise<AxiosResponse>;
    config(): Promise<AxiosResponse<CloudCliConfig>>;
    listProjects(): Promise<AxiosResponse<ProjectInfos[]>>;
    track(event: string, payload?: TrackPayload): Promise<AxiosResponse<void>>;
}
export declare function cloudApiFactory({ logger }: {
    logger: CLIContext['logger'];
}, token?: string): Promise<CloudApiService>;
//# sourceMappingURL=cli-api.d.ts.map