/// <reference types="lodash" />
import createPermissionsManager from './permission/permissions-manager';
import { cleanPermissionsInDatabase, createMany, deleteByIds, deleteByRolesIds, findMany, findUserPermissions } from './permission/queries';
declare const actionProvider: {
    hooks: {
        appliesPropertyToSubject: {
            call(context: unknown): Promise<any[]>;
            getHandlers(): import("@strapi/utils/dist/hooks").Handler[];
            register(handler: import("@strapi/utils/dist/hooks").Handler): import("@strapi/utils/dist/hooks").Hook<import("@strapi/utils/dist/hooks").Handler>;
            delete(handler: import("@strapi/utils/dist/hooks").Handler): import("@strapi/utils/dist/hooks").Hook<import("@strapi/utils/dist/hooks").Handler>;
        };
        willRegister: import("@strapi/utils/dist/hooks").AsyncSeriesHook;
        didRegister: import("@strapi/utils/dist/hooks").AsyncParallelHook;
        willDelete: import("@strapi/utils/dist/hooks").AsyncParallelHook;
        didDelete: import("@strapi/utils/dist/hooks").AsyncParallelHook;
    };
    register(actionAttributes: import("../domain/action").CreateActionPayload): Promise<import("@strapi/utils/dist/provider-factory").Provider>;
    registerMany(actionsAttributes: import("../domain/action").CreateActionPayload[]): Promise<any>;
    appliesToProperty(property: string, actionId: string, subject: string | null | undefined): Promise<boolean>;
    delete(key: string): Promise<import("@strapi/utils/dist/provider-factory").Provider>;
    get(key: string): {
        [x: string]: unknown;
    } | undefined;
    getWhere(filters?: Record<string, unknown> | undefined): {
        [x: string]: unknown;
    }[];
    values(): {
        [x: string]: unknown;
    }[];
    keys(): string[];
    has(key: string): boolean;
    size(): number;
    clear(): Promise<import("@strapi/utils/dist/provider-factory").Provider>;
};
declare const conditionProvider: {
    register(conditionAttributes: import("../domain/condition").CreateConditionPayload): Promise<import("@strapi/utils/dist/provider-factory").Provider>;
    registerMany(conditionsAttributes: import("../domain/condition").CreateConditionPayload[]): Promise<any>;
    hooks: import("@strapi/utils/dist/provider-factory").ProviderHooksMap;
    delete(key: string): Promise<import("@strapi/utils/dist/provider-factory").Provider>;
    get(key: string): {
        [x: string]: unknown;
    } | undefined;
    getWhere(filters?: Record<string, unknown> | undefined): {
        [x: string]: unknown;
    }[];
    values(): {
        [x: string]: unknown;
    }[];
    keys(): string[];
    has(key: string): boolean;
    size(): number;
    clear(): Promise<import("@strapi/utils/dist/provider-factory").Provider>;
};
declare const sectionsBuilder: {
    createSection(sectionName: string, options: import("./permission/sections-builder/section").SectionOptions): any;
    deleteSection(sectionName: string): any;
    addHandler(sectionName: string, handler: () => unknown): any;
    addMatcher(sectionName: string, matcher: () => unknown): any;
    build(actions?: import("../domain/action").Action[]): Promise<any>;
};
declare const sanitizePermission: (p: import("../../../shared/contracts/shared").Permission) => import("../../../shared/contracts/roles").SanitizedPermission;
declare const engine: {
    readonly hooks: import("@strapi/permissions/dist/engine/hooks").PermissionEngineHooks;
    generateUserAbility(user: import("../../../shared/contracts/shared").AdminUser): Promise<import("@casl/ability").Ability<import("@casl/ability").AbilityTuple, any>>;
    checkMany: import("lodash").CurriedFunction2<import("@casl/ability").Ability<import("@casl/ability").AbilityTuple, any>, import("../../../shared/contracts/shared").Permission[], boolean[]>;
};
export { cleanPermissionsInDatabase, createMany, deleteByIds, deleteByRolesIds, findMany, findUserPermissions, createPermissionsManager, sectionsBuilder, sanitizePermission, engine, actionProvider, conditionProvider, };
//# sourceMappingURL=permission.d.ts.map